'******************************************************************************
' UDP routines (IP required)
'******************************************************************************
'*******************************************************************************
'  Pollin NET-IO Board with Atmega32 / 644 / 644P and ENC28J60
'*******************************************************************************
'
'  Copyright bascom-forum.de (C) [2009]  [DON]
'  -> http://bascom-forum.de/index.php?topic=1781.new;topicseen#new
'  Software based on Code by Ben Zijlstra and Viktor Varga
'  Weiterentwickelt von
'    Huetti,
'    Michael
'    boeserkorn
'    mr_energy
'    HansHans
'    six1, Michael Kcher
'    dabuze                            datetime
'    framuel
'
'   http://creativecommons.org/licenses/by-sa/3.0/de/
'
'   Sie drfen:
'
'     * das Werk bzw. den Inhalt vervielfltigen, verbreiten und ffentlich zugnglich machen
'
'     * Abwandlungen und Bearbeitungen des Werkes bzw. Inhaltes anfertigen
'
'   Zu Den Folgenden Bedingungen:
'
'     * Namensnennung.
'       Sie mssen den Namen des Autors/Rechteinhabers in der von ihm festgelegten Weise nennen.
'
'     * Keine kommerzielle Nutzung.
'       Dieses Werk darf nicht fr kommerzielle Zwecke verwendet werden.
'
'     * Weitergabe unter gleichen Bedingungen.
'       Wenn Sie das lizenzierte Werk bzw. den lizenzierten Inhalt bearbeiten
'       oder in anderer Weise erkennbar als Grundlage fr eigenes Schaffen verwenden,
'       drfen Sie die daraufhin neu entstandenen Werke bzw. Inhalte nur
'       unter Verwendung von Lizenzbedingungen weitergeben, die mit denen
'       dieses Lizenzvertrages identisch oder vergleichbar sind.
'
'   Wobei gilt:
'
'     * Verzichtserklrung
'       Jede der vorgenannten Bedingungen kann aufgehoben werden, sofern Sie
'       die ausdrckliche Einwilligung des Rechteinhabers dazu erhalten.
'
'     * Sonstige Rechte
'       Die Lizenz hat keinerlei Einfluss auf die folgenden Rechte:
'          - Die gesetzlichen Schranken des Urheberrechts und sonstigen
'            Befugnisse zur privaten Nutzung
'          - Das Urheberpersnlichkeitsrecht des Rechteinhabers
'          - Rechte anderer Personen, entweder am Lizenzgegenstand selber oder
'            bezglich seiner Verwendung, zum Beispiel Persnlichkeitsrechte abgebildeter Personen.
'
'  Hinweis
'
'      Im Falle einer Verbreitung mssen Sie anderen alle Lizenzbedingungen
'      mitteilen, die fr dieses Werk gelten. Am einfachsten ist es,
'      einen Link auf http://creativecommons.org/licenses/by-sa/3.0/de/ einzubinden.
'

'*******************************************************************************
$nocompile
'-------------------------------------------------------------------------------
'  UDP traffic filter
'-------------------------------------------------------------------------------
Sub Udp_packet_filter

#if Include_dns > 0
   If Udp_w_dest_port = Udp_port_dns Then
      If Udp_w_src_port = Udp_port_dns Then
         Call Dns_packet_filter
      End If
      Exit Sub
   End If
#endif

#if Include_ntp > 0
   If Udp_w_dest_port = Udp_port_ntp Then
      If Udp_w_src_port = Udp_port_ntp Then
         Call Ntp_packet_filter
      End If
      Exit Sub
   End If
#endif

#if Include_dhcp > 0
   If Udp_w_dest_port = Udp_port_dhcp_local Then
      If Udp_w_src_port = Udp_port_dhcp_remote Then
         Call Dhcp_packet_filter
      End If
      Exit Sub
   End If
#endif

End Sub
                                     

'-------------------------------------------------------------------------------
'  Routine to calculate the UDP-checksum
'-------------------------------------------------------------------------------
Sub Udp_checksum
Local Lcrc32_l As Word
Local Lcrc32_h As Word
Local Lcrc32 As Long
Local Lword As Word
   Lcrc32 = 0
   Lword = Makeint(ip_b_srcaddr(2) , Ip_b_srcaddr(1))       'add bytes 1 and 2 (as word) from ip source address
   Lcrc32 = Lcrc32 + Lword
   Lword = Makeint(ip_b_srcaddr(4) , Ip_b_srcaddr(3))       'add bytes 3 and 4 (as word)  from ip source address
   Lcrc32 = Lcrc32 + Lword
   Lword = Makeint(ip_b_destaddr(2) , Ip_b_destaddr(1))     'add bytes 1 and 2  (as word) from ip dest address
   Lcrc32 = Lcrc32 + Lword
   Lword = Makeint(ip_b_destaddr(4) , Ip_b_destaddr(3))     'add bytes 3 and 4 (as word) from ip dest address
   Lcrc32 = Lcrc32 + Lword
   Lcrc32 = Lcrc32 + Ip_b_protocol                          'add ip protocol (as byte)
   Lword = Reversed_word(udp_w_packet_length)               'add udp packet length (as word)
   Lcrc32 = Lcrc32 + Lword
   Lcrc32_l = Lcrc32
   Lcrc32_h = Highw(lcrc32)
   Udp_w_chksum = &H00                                      'Initial chksum must be 0 during calculation
   Udp_w_chksum = Tcpchecksum(udp_header_start , Lword , Lcrc32_l , Lcrc32_h)       'this adds the former crc32 to the new chksum
End Sub

'-------------------------------------------------------------------------------
'   Compute UDP frame length from total package length
'-------------------------------------------------------------------------------
Sub Udp_set_packet_length(byval Packlength As Word)
   Packlength = Packlength - Eth_headerlength
   Packlength = Packlength - Ip_headerlength
   Udp_w_packet_length = Reversed_word(packlength)
End Sub

'-------------------------------------------------------------------------------
'   UDP dump header
'-------------------------------------------------------------------------------
#if Debug_udp > 0
Sub Udp_dump_header
Local Lw As Word
    Print "--------------------------------------------------------------------"
    Print "  UDP Header (8 Bytes)                                              "
    Print "--------------------------------------------------------------------"
    Print "Source Port: " ; : Call Print_word(udp_w_src_port , Crlf)
    Print " Dest. Port: " ; : Call Print_word(udp_w_dest_port , Crlf)
    Print "     Length :" ; : Call Print_word(udp_w_packet_length , Crlf)
    Print "   Checksum :" ; : Call Print_word(udp_w_chksum , Crlf)
End Sub
#endif